package com.framsticks.util.lang;

import java.util.Iterator;

// import org.apache.commons.collections.Closure;

public class Delimeted<T> {

	protected final String delimeter;
	protected final String empty;
	protected StringBuilder builder = null;

	/**
	 * @param delimeter
	 */
	public Delimeted(String delimeter, String empty) {
		this.delimeter = delimeter;
		this.empty = empty;
	}

	public final Delimeted<T> append(T object) {
		if (builder != null) {
			builder.append(delimeter);
		} else {
			builder = new StringBuilder();
		}
		builder.append(object);
		return this;
	}

	public final Delimeted<T> append(Iterator<T> i) {
		while (i.hasNext()) {
			append(i.next());
		}
		return this;
	}

	public final String build() {
		return (builder != null ? builder.toString() : empty);
	}

	@Override
	public String toString() {
		return build();
	}

	// @Override
	// public void execute(Object input) {
	// 	append(input);
	// }

}
