package com.framsticks.util.dispatching;

import javax.annotation.Nonnull;


public interface Joinable {

	/** The name of the joinable.
	 *
	 * It should never be empty, but it is not required to remain
	 * constant during lifetime of the object.
	 */
	public String getName();

	public boolean use(@Nonnull JoinableParent owner);
	public boolean drop(@Nonnull JoinableParent owner);

	public void join() throws InterruptedException;

	public JoinableState getState();

}
