package com.framsticks.util.dispatching;

import com.framsticks.util.FramsticksException;

public class DispatchingFuture<C, T> extends FutureHandler<T> {

	protected final Dispatcher<? super C> dispatcher;
	protected final FutureHandler<T> future;

	/**
	 * @param dispatcher
	 * @param future
	 */
	public DispatchingFuture(Dispatcher<? super C> dispatcher, FutureHandler<T> future) {
		this.dispatcher = dispatcher;
		this.future = future;
	}

	@Override
	public void handle(final FramsticksException exception) {
		Dispatching.dispatchIfNotActive(dispatcher, new RunAt<C>(ThrowExceptionHandler.getInstance()) {
			@Override
			protected void runAt() {
				future.handle(exception);
			}
		});
	}

	@Override
	protected void result(final T result) {
		Dispatching.dispatchIfNotActive(dispatcher, new RunAt<C>(future) {
			@Override
			protected void runAt() {
				future.pass(result);
			}
		});
	}

	public static <Ca, Ta> FutureHandler<Ta> create(Dispatcher<Ca> dispatcher, FutureHandler<Ta> future) {
		return new DispatchingFuture<Ca, Ta>(dispatcher, future);
	}

}
