package com.framsticks.util;

import java.io.InputStream;

import com.framsticks.params.annotations.ParamAnnotation;

public abstract class ResourceBuilder<T> implements Builder<T> {

	protected InputStream stream;

	/**
	 * @return the stream
	 */
	public InputStream getStream() {
		return stream;
	}

	/**
	 * @return the resource
	 */
	@ParamAnnotation
	public String getResource() {
		return resource;
	}

	/**
	 * @param stream the stream to set
	 */
	public ResourceBuilder<T> stream(InputStream stream) {
		this.stream = stream;
		return this;
	}

	protected String resource;

	@ParamAnnotation
	public ResourceBuilder<T> resource(String resource) {
		this.resource = resource;
		return stream(getClass().getResourceAsStream(resource));
	}
}
