package com.framsticks.util;

// import org.apache.logging.log4j.Logger;

/**
 * Author: Piotr Śniegowski
 */
public class Misc {
	// private static final Logger log =
	// 	LogManager.getLogger(Misc.class);

	public static class WithType {
		protected Object value;

		/**
		 * @param value
		 */
		public WithType(Object value) {
			this.value = value;
		}

		@Override
		public String toString() {
			if (value == null) {
				return "null";
			}
			return value + "(" + value.getClass() + ")";
		}
	}

	public static WithType withType(Object value) {
		return new WithType(value);
	}

	public static boolean equals(Object a, Object b) {
		// log.info("equality of {} ? {}", withType(a), withType(b));
		if (a != null) {
			return (b != null && a.equals(b));
		}
		return b == null;
	}

	public static <T> T returnNotNull(T first, T second) {
		if (first != null) {
			return first;
		}
		return second;
	}

	public static <T> T throwIfNull(T value) {
		if (value == null) {
			throw new FramsticksException().msg("value should not be null");
		}
		return value;
	}

	public static void checkEquals(Object expected, Object found, String message, Object context) {
		if (equals(expected, found)) {
			return;
		}
		FramsticksException e = new FramsticksException().msg(message).arg("expected", expected).arg("found", found);
		if (context != null) {
			e.arg("in", context);
		}
		throw e;
	}

	public static Class<?> getClass(Object object) {
		return (object != null ? object.getClass() : null);
	}
}
