package com.framsticks.util;

import org.apache.logging.log4j.Logger;


/**
 * @author Piotr Sniegowski
 */
public abstract class Logging {
	public static boolean log(Logger logger, String action, Object subject, Exception e) {
		if (e != null) {
			logger.error("failed to " + action + " " + subject + ": ", e);
			return true;
		}
		if (logger.isDebugEnabled()) {
			logger.debug("done: " + action + " " + subject);
		}
		return false;
	}

	public static ExceptionHandler logger(final Logger logger, final String action, final Object subject) {
		return new ExceptionHandler() {
			@Override
			public void handle(FramsticksException e) {
				Logging.log(logger, action, subject, e);
			}
		};
	}

	public static <T> T passThru(Logger log, String header, T value) {
		log.info("{}: {}", header, value);
		return value;
	}
}
