package com.framsticks.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DoubleMap<K, V> {

	protected final Map<K, V> byId = new HashMap<>();
	protected final Map<K, V> byName = new HashMap<>();
	protected final Set<V> values = new HashSet<>();

	public int size() {
		return values.size();
	}

	public void put(K id, K name, V value) {
		values.add(value);
		if (id != null) {
			byId.put(id, value);
		}
		if (name != null) {
			byName.put(name, value);
		}
	}

	public boolean containsValue(V value) {
		return values.contains(value);

	}

	public boolean containsKey(K identifier) {
		return byId.containsKey(identifier) || byName.containsKey(identifier);
	}

	public V get(K identifier) {
		if (byId.containsKey(identifier)) {
			return byId.get(identifier);
		}
		if (byName.containsKey(identifier)) {
			return byName.get(identifier);
		}
		return null;
	}

	public Set<V> getValues() {
		return Collections.unmodifiableSet(values);
	}

	public Map<K, V> getValuesById() {
		return Collections.unmodifiableMap(byId);
	}

}
