package com.framsticks.test.prime;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;

@FramsClassAnnotation
public class ExpParams {

	@ParamAnnotation
	public int from_number;

	@ParamAnnotation
	public int to_number;

	/**
	 *
	 */
	public ExpParams() {
	}

	/**
	 * @param from_number
	 * @param to_number
	 */
	public ExpParams(int from_number, int to_number) {
		this.from_number = from_number;
		this.to_number = to_number;
	}

	@Override
	public String toString() {
		return "[" + from_number + ":" + to_number + "]";
	}

	public boolean isInsideOf(ExpParams outer) {
		return from_number >= outer.from_number && to_number <= outer.to_number;
	}
}
