package com.framsticks.test;

import java.util.Map;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.params.EventListener;
import com.framsticks.params.SimplePrimitive;
import com.framsticks.params.SimpleUniqueList;
import com.framsticks.params.annotations.AutoAppendAnnotation;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.params.types.ProcedureParam;
import com.framsticks.structure.messages.ListChange;
import com.framsticks.structure.messages.ValueChange;

@FramsClassAnnotation(
	order = {
		"name",
		"history",
		"history_changed",
		"appendHistory",
		"resetHistory",
		"children",
		"createChild",
		"children_changed"
	}
)
public class TestClass {
	private static final Logger log = LogManager.getLogger(TestClass.class);


	protected String name = "test";
	protected final SimplePrimitive<String> history = new SimplePrimitive<>("initial|");

	protected final SimpleUniqueList<TestChild> children = new SimpleUniqueList<>(TestChild.class, 'c');

	/**
	 *
	 */
	public TestClass() {
	}

	/**
	 * @return the name
	 */
	@ParamAnnotation
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	@ParamAnnotation
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the history
	 */
	@ParamAnnotation
	public String getHistory() {
		return history.get();
	}

	/**
	 * @param history the history to set
	 */
	@ParamAnnotation
	public void setHistory(String history) {
		this.history.set(history);
	}

	/**
	 * @return the children
	 */
	@ParamAnnotation
	public Map<String, TestChild> getChildren() {
		return children.getMap();
	}

	@ParamAnnotation(paramType = ProcedureParam.class)
	public int appendHistory(String line) {
		log.debug("appending '{}'", line);
		history.set(history.get() + line + "|");
		// fireHistoryChange();
		return history.get().length();
	}

	@ParamAnnotation(paramType = ProcedureParam.class)
	public void resetHistory() {
		log.debug("reseting");
		history.set("");
	}

	@ParamAnnotation(paramType = ProcedureParam.class)
	public void createChild(String name) {
		TestChild child = new TestChild();
		child.name = name;
		addChild(child);
	}

	@AutoAppendAnnotation
	public void addChild(TestChild child) {
		child.parent = this;
		children.add(child);
	}

	@ParamAnnotation(id = "history_changed")
	public void addHistoryListener(EventListener<ValueChange> listener) {
		history.addListener(listener);
	}

	@ParamAnnotation(id = "history_changed")
	public void removeHistoryListener(EventListener<ValueChange> listener) {
		history.removeListener(listener);
	}

	@ParamAnnotation(id = "children_changed")
	public void addChildrenListener(EventListener<ListChange> listener) {
		children.addListener(listener);
	}

	@ParamAnnotation(id = "children_changed")
	public void removeChildrenListener(EventListener<ListChange> listener) {
		children.removeListener(listener);
	}

	@Override
	public String toString() {
		return "test class " + history;
	}


}
