package com.framsticks.structure;

import javax.annotation.Nonnull;

import com.framsticks.communication.queries.NeedFileAcceptor;
import com.framsticks.params.Access;
import com.framsticks.params.CompositeParam;
import com.framsticks.params.EventListener;
import com.framsticks.params.FramsClass;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.params.Registry;
import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.ProcedureParam;
import com.framsticks.util.ExceptionHandler;
import com.framsticks.util.dispatching.Dispatcher;
import com.framsticks.util.dispatching.DispatcherSetable;
import com.framsticks.util.dispatching.FutureHandler;
import com.framsticks.util.dispatching.Joinable;

public interface Tree extends Dispatcher<Tree>, DispatcherSetable<Tree>, Joinable, ExceptionHandler {

	public @Nonnull Node getAssignedRoot();
	public void assignRootParam(CompositeParam param);
	public void assignRootObject(Object object);

	public @Nonnull Access prepareAccess(CompositeParam param);
	public void takeAllFrom(Registry source);

	public FramsClass getInfoFromCache(String id);

	public void putInfoIntoCache(FramsClass framclass);

	// /**
	//  *
	//  * Functions accepts ValueParam, because it is also possible to get number of List elements.
	//  *
	//  */
	// public void get(Path path, ValueParam param, Future<Object> future);

	public void get(Path path, FutureHandler<Path> future);

	public <R> void call(Path path, ProcedureParam param, Object[] arguments, Class<R> resultType, FutureHandler<R> future);

	/**
	 *
	 * Functions accepts PrimitiveParam<?>, because it is not possible to set number of List elements.
	 *
	 */
	public void set(Path path, PrimitiveParam<?> param, Object value, FutureHandler<Integer> future);

	public void info(Path path, FutureHandler<FramsClass> future);

	public void setExceptionHandler(ExceptionHandler handler);

	public ExceptionHandler getExceptionHandler();

	// public void setDispatcher(Dispatcher<Tree> dispatcher);

	// public Dispatcher<Tree> getDispatcher();

	public <A> void addListener(Path path, EventParam param, EventListener<A> listener, Class<A> argumentType, FutureHandler<Void> future);

	public void removeListener(Path path, EventParam param, EventListener<?> listener, FutureHandler<Void> future);

	public Registry getRegistry();

	public <T> void putSideNote(Object object, SideNoteKey<T> key, T value);

	public <T> T getSideNote(Object object, SideNoteKey<T> key);

	public boolean removeSideNote(Object object, SideNoteKey<?> key);

	public void addNeedFileAcceptor(int priority, NeedFileAcceptor acceptor);

	public void removeNeedFileAcceptor(NeedFileAcceptor acceptor);

}
