package com.framsticks.structure;

import com.framsticks.util.FramsticksException;

public class SideNoteKey<T> {

	protected final Class<T> type;

	/**
	 * @param type
	 */
	public SideNoteKey(Class<T> type) {
		this.type = type;
	}

	public static <T2> SideNoteKey<T2> make(Class<T2> type) {
		return new SideNoteKey<T2>(type);
	}

	public T newValue() {
		try {
			return type.newInstance();
		} catch (InstantiationException | IllegalAccessException e) {
			throw new FramsticksException().msg("failed to create side note value").arg("type", type).cause(e);
		}
	}

}
