package com.framsticks.structure;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

import com.framsticks.params.CompositeParam;
import com.framsticks.util.FramsticksException;
// import com.framsticks.params.ParamBuilder;
import com.framsticks.util.lang.Strings;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class Node {

	protected final Tree tree;
	protected final CompositeParam param;
	protected final Object object;

	public Node(Tree tree, @Nonnull CompositeParam param, Object object) {
		assert param != null;
		assert tree != null;
		this.tree = tree;
		this.param = param;
		this.object = object;
	}


	public final Tree getTree() {
		return tree;
	}

	public final CompositeParam getParam() {
		return param;
	}

	public final Object getObject() {
		return object;
	}

	@Override
	public String toString() {
		return param.toString() + ":" + Strings.toStringNullProof(object, "<null>");
	}

	public final boolean isResolved() {
		return object != null;
	}

	public Node assureResolved() {
		if (!isResolved()) {
			throw new FramsticksException().msg("path is not resolved").arg("node", this);
		}
		return this;
	}

}
