package com.framsticks.running;



import com.framsticks.params.ParamFlags;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.lang.Strings;

@FramsClassAnnotation
public class FramsServer extends ExternalProcess {

	protected Integer port;
	protected String path;
	protected String expdef;

	/**
	 *
	 */
	public FramsServer() {
		super();
		setCommand("frams.linux");
		setPath("opt/framsticks");
		setName("frams");
	}


	/**
	 * @return the port
	 */
	@ParamAnnotation(flags = ParamFlags.USERREADONLY)
	public Integer getPort() {
		return port;
	}

	/**
	 * @param port the port to set
	 */
	@ParamAnnotation
	public void setPort(Integer port) {
		this.port = port;
	}

	/**
	 * @return the path
	 */
	@ParamAnnotation(flags = ParamFlags.USERREADONLY)
	public String getPath() {
		return path;
	}

	/**
	 * @param path the path to set
	 */
	@ParamAnnotation
	public void setPath(String path) {
		this.path = path;
		setDirectory(path);
	}

	/**
	 * @return the expdef
	 */
	@ParamAnnotation(flags = ParamFlags.USERREADONLY)
	public String getExpdef() {
		return expdef;
	}

	/**
	 * @param expdef the expdef to set
	 */
	@ParamAnnotation
	public void setExpdef(String expdef) {
		this.expdef = expdef;
	}

	@Override
	protected void joinableStart() {
		if (port != null) {
			arguments.add("-n");
			arguments.add("-p" + port);
		}
		if (Strings.notEmpty(expdef)) {
			arguments.add("Simulator.expdef=\"" + expdef + "\";");
		}
		// log.debug("running {} with arguments {}", getCommand(), arguments);
		super.joinableStart();
	}

}
