package com.framsticks.parsers;

import com.framsticks.params.Access;
import com.framsticks.params.FramsClass;
import com.framsticks.params.Param;
import com.framsticks.params.ReflectionAccess;
import com.framsticks.params.Sink;
import static com.framsticks.params.AccessOperations.*;

/**
 * @author Piotr Sniegowski
 */
public class Savers {
	public static <S extends Sink> S saveFramsClass(S sink, FramsClass framsClass) {

		Access framsClassAccess = new ReflectionAccess(FramsClass.class);
		Access paramAccess = new ReflectionAccess(Param.class);
		framsClassAccess.select(framsClass);

		save(framsClassAccess, sink);
		for (Param p : framsClass.getParams()) {
			save(paramAccess.select(p), sink);
		}
		return sink;
	}

}
