package com.framsticks.params.types;

import com.framsticks.params.CastFailure;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.ParamsUtil;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.params.ReassignResult;

import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class UniversalParam extends PrimitiveParam<Object> {


	/**
	 * @param builder
	 */
	public UniversalParam(ParamBuilder builder) {
		super(builder);
	}

	@Override
	public Class<?> getStorageType() {
		return Object.class;
	}

	@Override
	public String getFramsTypeName() {
		return "x";
	}

	@Override
	public ReassignResult<Object> reassign(Object newValue, Object oldValue) throws CastFailure {
		if (newValue instanceof String) {
			return ReassignResult.create(ParamsUtil.deserialize((String) newValue, Object.class));
		}
		return ReassignResult.create(newValue);
	}

	@Override
	public <T> String serialize(T value) {
		return ParamsUtil.serialize(value);
	}


}
