package com.framsticks.params.types;

import com.framsticks.params.Param;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.ValueParam;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class ProcedureParam extends Param {
	private final ValueParam resultType;
	private final List<ValueParam> argumentsType;
	private final String signatureString;

	/**
	 * @param builder
	 */
	public ProcedureParam(ParamBuilder builder) {
		super(builder);
		resultType = builder.getResultType();
		argumentsType = builder.getArgumentsType();
		assert argumentsType != null;

		StringBuilder b = new StringBuilder().append("p");

		if (resultType != null) {
			b.append(" ").append(resultType.getFramsTypeName());
		}
		b.append("(");
		boolean first = true;
		for (ValueParam arg : argumentsType) {
			if (first) {
				first = false;
			} else {
				b.append(", ");
			}

			b.append(arg.getFramsTypeName());
			if (arg.getName() != null) {
				b.append(" ").append(arg.getName());
			}
		}
		b.append(")");

		signatureString = b.toString();
	}

	public @Nullable ValueParam getResultType() {
		return resultType;
	}

	public List<ValueParam> getArgumentsType() {
		return argumentsType;
	}

	@Override
	public String getFramsTypeName() {
		return signatureString;
	}

}
