package com.framsticks.params.types;

import com.framsticks.params.Access;
import com.framsticks.params.CastFailure;
import com.framsticks.params.CompositeParam;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.ReassignResult;

import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class ObjectParam extends CompositeParam {

	protected final Class<?> storageType;

	public ObjectParam(ParamBuilder builder) {
		super(builder.fillStorageType(Object.class));
		storageType = builder.getStorageType();
	}

	@Override
	public String computeAccessId() {
		return containedTypeName;
	}

	@Override
	public Class<?> getStorageType() {
		return storageType;
	}

	@Override
	public ReassignResult<Object> reassign(Object newValue, Object oldValue) throws CastFailure {
		if (newValue != null && !storageType.isInstance(newValue)) {
			throw new CastFailure();
		}
		return ReassignResult.create(newValue);
	}

	@Override
	public Access prepareAccess(Access access) {
		return access;
	}

	@Override
	public String getFramsTypeName() {
		return "o " + containedTypeName;
	}

	// @Override
	// public <T> String serialize(T value) {
	// 	return ParamsUtil.serialize(value);
	// }

}
