package com.framsticks.params.types;

import com.framsticks.params.CastFailure;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.ReassignResult;

import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class FloatParam extends NumberParam<Double> {

	/**
	 * @param builder
	 */
	public FloatParam(ParamBuilder builder) {
		super(builder.fillDef(0.0).fillStorageType(Double.class));
	}

	@Override
	public Class<?> getStorageType() {
		return Double.class;
	}

	@Override
	public ReassignResult<Double> reassign(Object newValue, Object oldValue) throws CastFailure {
		return reassignNumber(newValue, oldValue, Double.class);
	}

	@Override
	public String getFramsTypeName() {
		return "f";
	}


}
