package com.framsticks.params.types;

import java.util.List;

import com.framsticks.params.ParamBuilder;

import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class EnumParam extends DecimalParam {


	protected final List<String> enums;

	/**
	 * This constructor exists because EnumParam is different package than ParamBuilder.
	 *
	 * @param enums
	 */
	public EnumParam(ParamBuilder builder) {
		super(builder);
		this.enums = builder.getEnumValues();
		assert(this.enums != null);
	}

	public List<String> getElements() {
		return enums;
	}



}
