package com.framsticks.params;

import com.framsticks.structure.messages.ValueChange;
import com.framsticks.util.lang.Strings;

public class SimplePrimitive<T> {

	protected T value;
	protected final EventListeners<ValueChange> listeners = new EventListeners<>();

	/**
	 * @param value
	 */
	public SimplePrimitive(T value) {
		this.value = value;
	}

	/**
	 * @param value
	 */
	public SimplePrimitive() {
		this(null);
	}

	/**
	 * @return the value
	 */
	public T get() {
		return value;
	}

	/**
	 * @param value the value to set
	 */
	public void set(T value) {
		this.value = value;
		listeners.actionForAll(new ValueChange(value != null ? value.toString() : null));
	}

	public void addListener(EventListener<ValueChange> listener) {
		listeners.add(listener);
	}

	public void removeListener(EventListener<ValueChange> listener) {
		listeners.remove(listener);
	}

	@Override
	public String toString() {
		return Strings.toStringNullProof(value);
	}

}
