package com.framsticks.params;

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.TreeMap;

import com.framsticks.util.lang.Casting;

public class MapBasedObject implements Iterable<Map.Entry<String, Object>> {

	protected final String framsTypeName;
	protected final Map<String, Object> values = new TreeMap<>();

	/**
	 * @param framsTypeName
	 */
	public MapBasedObject(String framsTypeName) {
		this.framsTypeName = framsTypeName;
	}

	public <T> void set(String id, T value) {
		values.put(id, value);
	}

	public <T> T get(String id, Class<T> type) {
		return Casting.nullOrThrowCast(type, values.get(id));
	}

	public void clear() {
		values.clear();
	}

	public int size() {
		return values.size();
	}

	@Override
	public String toString() {
		return values.toString();
	}

	/**
	 * @return the framsTypeName
	 */
	public String getFramsTypeName() {
		return framsTypeName;
	}

	@Override
	public Iterator<Entry<String, Object>> iterator() {
		return values.entrySet().iterator();
	}

}
