package com.framsticks.params;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListSource implements Source {

	private Iterator<String> iterator = null;
	private final List<String> list;

	public ListSource(List<String> list) {
		this.list = list;
		iterator = list.iterator();
	}

	@Override
	public String getFilename() {
		return "<net>";
	}

	@Override
	public String readLine() {
		// if (iterator == null) {
		//	return null;
		// }
		assert iterator != null;
		if (iterator.hasNext()) {
			return iterator.next();
		}
		return null;
	}

	@Override
	public String demangleInclude(String include) {
		return null;
	}

	@Override
	public Source openInclude(String include) {
		return null;
	}

	@Override
	public void close() {
		iterator = null;
	}

	public static ListSource createFrom(String... lines) {
		List<String> list = new ArrayList<String>();
		for (String l : lines) {
			list.add(l);
		}
		return new ListSource(list);
	}

	@Override
	public boolean isClosed() {
		return iterator == null;
	}

	@Override
	public String toString() {
		if (list.isEmpty()) {
			return "?";
		}
		StringBuilder b = new StringBuilder();
		int print = Math.min(list.size(), 3);
		for (int i = 0; i < print; ++i) {
			if (i != 0) {
				b.append(" ");
			}
			b.append(list.get(i));
		}
		if (list.size() > print) {
			b.append(" ...");
		}
		return b.toString();
	}

}
