package com.framsticks.params;

import java.util.List;

import javax.annotation.concurrent.Immutable;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.lang.Containers;

/**
 * @author Piotr Sniegowski
 */
@FramsClassAnnotation
@Immutable
public class Group {

	@ParamAnnotation
	protected final String name;

	/**
	 * Group members.
	 */
	protected final List<Param> params;

	public Group(GroupBuilder builder) {
		this.name = builder.getName();
		this.params = builder.getParams();
	}

	/**
	 * Gets the property.
	 *
	 * @param i the i
	 * @return the property
	 */
	public Param getParam(int number) {
		return Containers.getFromList(params, number, "param", this);
	}

	@Override
	public String toString() {
		return "group" + name;
	}

	/**
	 * @return the name
	 */
	@ParamAnnotation
	public String getName() {
		return name;
	}

	public int getCount() {
		return params.size();
	}

}
