package com.framsticks.params;

import java.util.Iterator;
import java.util.Map;

import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.ObjectParam;
import com.framsticks.params.types.ProcedureParam;
import com.framsticks.params.types.UniversalParam;
import com.framsticks.util.UnimplementedException;

public class FreeAccess implements ObjectAccess {

	protected FreeObject object;

	protected final String typeName;

	/**
	 * @param typeName
	 */
	public FreeAccess(String typeName) {
		this.typeName = typeName;
	}

	@Override
	public Param getParam(int i) {
		throw new InvalidOperationException();
	}

	@Override
	public Param getParam(String id) {
		return Param.build().type(UniversalParam.class).idAndName(id).finish();
	}

	@Override
	public int getParamCount() {
		return object.size();
	}

	@Override
	public Iterable<Param> getParams() {
		return new Iterable<Param>() {

			@Override
			public Iterator<Param> iterator() {
				return new Iterator<Param>() {

					protected final Iterator<Map.Entry<String, Object>> internal = object.iterator();

					@Override
					public boolean hasNext() {
						return internal.hasNext();
					}

					@Override
					public Param next() {
						return Param.build().idAndName(internal.next().getKey()).type(UniversalParam.class).finish(Param.class);
					}

					@Override
					public void remove() {
						throw new UnimplementedException().msg("remove element from FreeAccess").arg("access", FreeAccess.this);
					}
				};
			}
		};
	}

	@Override
	public String getTypeId() {
		return typeName;
	}

	@Override
	public Object call(String id, Object... arguments) {
		throw new InvalidOperationException().msg("properties access does not support calling methods").arg("id", id);
	}

	@Override
	public Object call(ProcedureParam param, Object... arguments) {
		throw new InvalidOperationException().msg("properties access does not support calling methods").arg("param", param);
	}

	@Override
	public <T> T get(int i, Class<T> type) {
		throw new InvalidOperationException();
	}

	@Override
	public <T> T get(String id, Class<T> type) {
		return object.get(id, type);
	}

	@Override
	public <T> T get(ValueParam param, Class<T> type) {
		return get(param.getId(), type);
	}

	@Override
	public <T> int set(int i, T value) {
		throw new InvalidOperationException();
	}

	@Override
	public <T> int set(String id, T value) {
		object.set(id, (value instanceof String) ? ParamsUtil.deserialize((String) value) : value);
		return 0;
	}

	@Override
	public <T> int set(ValueParam param, T value) {
		return set(param.getId(), value);
	}

	@Override
	public void reg(EventParam param, EventListener<?> listener) {
		throw new InvalidOperationException().msg("properties access does not support registering events").arg("param", param).arg("access", this);
	}

	@Override
	public void regRemove(EventParam param, EventListener<?> listener) {
		throw new InvalidOperationException().msg("properties access does not support registering events").arg("param", param).arg("access", this);
	}

	@Override
	public void clearValues() {
		object.clear();
	}

	@Override
	public Access select(Object object) {
		this.object = ParamsUtil.selectObjectForAccess(this, object, FreeObject.class);
		return this;
	}

	@Override
	public Object getSelected() {
		return object;
	}

	@Override
	public Access cloneAccess() {
		return new FreeAccess(typeName);
	}

	@Override
	public Object createAccessee() {
		return new FreeObject(typeName);
	}

	@Override
	public FramsClass getFramsClass() {
		throw new InvalidOperationException();
	}

	@Override
	public void tryAutoAppend(Object object) {
		throw new InvalidOperationException();
	}

	@Override
	public int getCompositeParamCount() {
		return 0;
	}

	@Override
	public CompositeParam getCompositeParam(int number) {
		throw new InvalidOperationException();
	}

	@Override
	public ParamBuilder buildParam(ParamBuilder builder) {
		return builder.name(typeName).type(ObjectParam.class).containedTypeName(typeName);
	}

	@Override
	public String toString() {
		return "FreeAccess[" + typeName + "]";
	}

}
