package com.framsticks.model.f0;

import java.io.InputStream;
import java.util.Set;

import com.framsticks.params.*;
import com.framsticks.params.annotations.AutoAppendAnnotation;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.lang.Casting;


/**
 * The Class Schema, which represent f0 schema (it contains all the possible
 * classes definitions that can be used in f0 representation). Definitions are
 * loaded from XML stream.
 *
 * @author Jarek Szymczak <name.surname@gmail.com>
 * (please replace name and surname with my personal data)
 */
@FramsClassAnnotation(id = "f0classes", name = "f0classes")
public class Schema {

	protected final Registry registry = new Registry();

	/** The neuro classes (classess representing different types of neurons). */
	private final Registry framsClasses = new Registry();
	private final Registry neuroClasses = new Registry();
	// private DoubleMap<String, FramsClass> framsClasses = new DoubleMap<>();
	// private DoubleMap<String, NeuroClass> neuroClasses = new DoubleMap<>();

	public static InputStream getDefaultDefinitionAsStream() {
		//return new FileInputStream(new File(Schema.class.getResource("/parsers/f0def.xml").getPath()));
		return Schema.class.getResourceAsStream("/parsers/f0def.xml");
	}

	private static Schema defaultSchema;

	public synchronized static Schema getDefaultSchema() {
		if (defaultSchema == null) {
			defaultSchema = new SchemaBuilder().stream(getDefaultDefinitionAsStream()).finish();
		}
		return defaultSchema;
	}

	public Schema() {
	}

	@AutoAppendAnnotation
	public void addClass(FramsClass framsClass) {
		registry.putFramsClass(framsClass);
		if (framsClass instanceof NeuroClass) {
			neuroClasses.putFramsClass(framsClass);
			return;
		}
		framsClasses.putFramsClass(framsClass);
	}

	@AutoAppendAnnotation
	public void addClass(FramsClassBuilder builder) {
		addClass(builder.finish());
	}

	public Set<FramsClass> getNeuroClasses() {
		return neuroClasses.getFramsClasses();
	}

	public Set<FramsClass> getFramsClasses() {
		return framsClasses.getFramsClasses();
	}

	public NeuroClass getNeuroClass(String identifier) {
		return Casting.throwCast(NeuroClass.class, neuroClasses.getFramsClass(identifier));
	}

	public FramsClass getFramsClass(String identifier) {
		return framsClasses.getFramsClass(identifier);
	}

	@ParamAnnotation
	public final Registry getRegistry() {
		return registry;
	}

	@ParamAnnotation
	public final Registry getFramsRegistry() {
		return framsClasses;
	}

	@ParamAnnotation
	public final Registry getNeurosRegistry() {
		return neuroClasses;
	}


}
