package com.framsticks.model.f0;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.annotation.concurrent.Immutable;

import com.framsticks.params.FramsClass;
import com.framsticks.params.annotations.FramsClassAnnotation;

import static com.framsticks.util.Misc.throwIfNull;
import static com.framsticks.util.Misc.returnNotNull;

@Immutable
@FramsClassAnnotation(id = "neuroclass", name = "neuroclass")
public class NeuroClass extends FramsClass {


	public NeuroClass(NeuroClassBuilder builder) {
		super(builder);

		preferredInputs = throwIfNull(builder.getPreferredInputs());
		preferredOutput = throwIfNull(builder.getPreferredOutput());
		preferredLocation = throwIfNull(builder.getPreferredLocation());
		visualHints = returnNotNull(builder.getVisualHints(), 0);

		if (builder.getSymbolGlyph() != null) {
			symbolGlyph = new ArrayList<>();
			for (String s : builder.getSymbolGlyph().split(",")) {
				symbolGlyph.add(Integer.valueOf(s));
			}
		} else {
			symbolGlyph = null;
		}

	}

	protected final int preferredInputs;

	protected final int preferredOutput;

	protected final int preferredLocation;

	protected final int visualHints;

	protected final List<Integer> symbolGlyph;

	/**
	 * @return the preferredInputs
	 */
	public int getPreferredInputs() {
		return preferredInputs;
	}

	/**
	 * @return the preferredOutput
	 */
	public int getPreferredOutput() {
		return preferredOutput;
	}

	/**
	 * @return the preferredLocation
	 */
	public int getPreferredLocation() {
		return preferredLocation;
	}

	/**
	 * @return the visualHints
	 */
	public int getVisualHints() {
		return visualHints;
	}

	/**
	 * @return the symbolGlyph
	 */
	public List<Integer> getSymbolGlyph() {
		return Collections.unmodifiableList(symbolGlyph);
	}

}
