package com.framsticks.model;


import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.math.Point3d;

/**
 * The Class Part.
 */
@FramsClassAnnotation(id = "p")
public class Part extends BasePart implements ModelComponent {

	@ParamAnnotation(id = "rx")
	public double rotationX;

	@ParamAnnotation(id = "ry")
	public double rotationY;

	@ParamAnnotation(id = "rz")
	public double rotationZ;

	public Point3d getRotation() { return new Point3d(rotationX, rotationY, rotationZ); }
	public void setRotation(Point3d r) { rotationX = r.x; rotationY = r.y; rotationZ = r.z; }

	@ParamAnnotation(id = "dn")
	public double density;

	@ParamAnnotation(id = "ing")
	public double ingestion;

	@ParamAnnotation(id = "as")
	public double assimilation;

	@ParamAnnotation(id = "i")
	public String info;

	@ParamAnnotation(id = "Vstyle")
	public String visualizationStyle;

	@ParamAnnotation(id = "vs")
	public double visualThickness;

	@ParamAnnotation
	public double vr, vg, vb;

}
