package com.framsticks.gui.windows;

import com.framsticks.gui.ImageProvider;
import org.apache.logging.log4j.LogManager;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Frame displaying manager logs.
 */
@SuppressWarnings("serial")
public class ServerLogFrame extends JFrame {
	public JTextArea logText;
	private int levelReporting = -1;
	private boolean popUp = true;

	private final static String[] STR_ = {"DEBUG", "INFO", "WARNING", "ERROR",
			"CRITICAL"};


	public ServerLogFrame() {

		super("FNC - Manager Log");
		Dimension size = new Dimension(440, 400);
		this.setSize(size);
		this.setMinimumSize(size);
		this.setIconImage(ImageProvider.loadImage(ImageProvider.LOGO).getImage());
		JFrame.setDefaultLookAndFeelDecorated(true);
		/*
		try {
			UIManager
					.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
		} catch (Exception ex) {
		}
		*/
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		logText = new JTextArea();
		//logText.setFont(Control.FONT);
		logText.setEditable(false);
		logText.setWrapStyleWord(true);
		logText.setLineWrap(true);
		JComboBox<String> levelBox = new JComboBox<String>();
		for (String i : STR_) {
			levelBox.addItem(i);
		}
		levelBox.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				levelReporting = ((JComboBox<?>) e.getSource()).getSelectedIndex();
			}
		});
		JCheckBox logPopup = new JCheckBox();
		logPopup.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				popUp = ((JCheckBox) e.getSource()).isSelected();
			}
		});
		logPopup.setSelected(true);
		JLabel levelLabel = new JLabel("Select reporting level ");
		JLabel popupLabel = new JLabel("Window popup ? ");
		JPanel panel = new JPanel();
		panel.setLayout(new FlowLayout());
		panel.add(levelLabel);
		panel.add(levelBox);
		panel.add(logPopup);
		panel.add(popupLabel);
		JScrollPane scrollPane = new JScrollPane(logText);
		scrollPane.setBorder(BorderFactory.createEtchedBorder());
		Container contentPane = this.getContentPane();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(scrollPane, BorderLayout.CENTER);
		contentPane.add(panel, BorderLayout.SOUTH);
		levelReporting = 0;
	}

	public void setLevelReporting(int level) {
		levelReporting = level;
	}

	public void log(int level, String clazz, String function,
	                String message) {
		if (level >= levelReporting) {
			if (popUp && !this.isVisible())
				this.setVisible(true);
			LogManager.getLogger(ServerLogFrame.class).error(
					"level " + level + " class " + clazz + " function "
							+ function + " msg " + message);
			logText.append("[" + STR_[level] + "] " + clazz + "::"
					+ function + " - " + message + "\n");
		}
	}

	/**
	 * Shows frame sets location relative to parent.
	 *
	 * @param parent Frame relative to which console window will be localized.
	 */
	public void show(final JFrame parent) {
		if (parent != null) {
			final Point parentLocation = parent.getLocation();
			final Point location = new Point(parentLocation.x + 20,
					parentLocation.y + 20);
			this.setLocation(location);
		}
		this.setVisible(true);
	}
}
