package com.framsticks.gui.tree;

import java.util.LinkedList;
import java.util.List;


import com.framsticks.gui.AbstractPanel;
import com.framsticks.gui.Frame;
import com.framsticks.gui.ImageProvider;

public class MetaNode extends AbstractNode {

	protected final Frame frame;
	protected final List<Object> children = new LinkedList<>();
	protected String name = "meta node";

	/**
	 * @param frame
	 */
	public MetaNode(Frame frame) {
		this.frame = frame;
	}

	/**
	 * @return the children
	 */
	public List<Object> getChildren() {
		return children;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	@Override
	public int getChildCount() {
		return children.size();
	}

	@Override
	public Object getChild(int number) {
		return children.get(number);
	}

	@Override
	public int getIndexOfChild(Object child) {
		return children.indexOf(child);
	}

	@Override
	public String toString() {
		return name;
	}

	@Override
	public boolean isLeaf() {
		return false;
	}

	@Override
	public void render(TreeCellRenderer renderer) {
		renderer.setIcon(ImageProvider.loadImage(ImageProvider.SERVER));
		renderer.setText(name);
		renderer.setToolTipText("?");
	}

	@Override
	public AbstractPanel getPanel() {
		return frame.getEmptyPanel();
	}

}
