package com.framsticks.gui.table;

import java.util.LinkedList;
import java.util.List;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class AbstractTableModel implements javax.swing.table.TableModel {

	protected final List<TableModelListener> listeners = new LinkedList<>();

	@Override
	public void addTableModelListener(TableModelListener listener) {
		listeners.add(listener);
	}

	@Override
	public void removeTableModelListener(TableModelListener listener) {
		listeners.remove(listener);
	}

	protected void notifyAll(TableModelEvent event) {
		for (TableModelListener l : listeners) {
			l.tableChanged(event);
		}
	}

	public void refreshAll() {
		notifyAll(new TableModelEvent(this));
	}
}
