package com.framsticks.gui.controls;

import com.framsticks.gui.Gui;
import com.framsticks.params.PrimitiveParam;

import javax.swing.*;
import javax.swing.text.JTextComponent;

import java.awt.*;

@SuppressWarnings("serial")
public class TextAreaControl extends TextOnlyControl {

	protected final JTextArea textArea;
	protected final JScrollPane textScrollPane;

	public TextAreaControl(PrimitiveParam<?> valueParam) {
		super(valueParam);
		textArea = new JTextArea();
		textArea.setName("value");
		textArea.setLineWrap(true);
		textArea.setWrapStyleWord(true);
		addDefaultDocumentListener(textArea);

		textScrollPane = new JScrollPane(textArea);
		this.setLayout(new BorderLayout());
		this.add(textScrollPane, BorderLayout.CENTER);
		int maxSize = LINE_HEIGHT * 10;
		this.setMaximumSize(new Dimension(Integer.MAX_VALUE, maxSize));
		textArea.setMaximumSize(new Dimension(Integer.MAX_VALUE, maxSize));

		Gui.setupTitledControl(this, textScrollPane);
		// this.revalidate();
	}

	@Override
	public Dimension getPreferredSize() {
		Dimension result = super.getPreferredSize();
		return new Dimension(result.width, Math.min(result.height, this.getMaximumSize().height));
	}

	@Override
	protected JTextComponent getTextComponent() {
		return textArea;
	}

	@Override
	public void pushValueToUserInterfaceImpl(Object value) {
		// getTextComponent().setText(getParam().serialize(value));
		super.pushValueToUserInterfaceImpl(value);
		this.revalidate();
	}

	@Override
	protected void updateEnabled(boolean enabled) {
		textArea.setEditable(enabled);
	}

}
