package com.framsticks.gui.controls;

import com.framsticks.gui.Gui;
import com.framsticks.params.types.EnumParam;
import com.framsticks.util.lang.Numbers;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import javax.swing.*;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

@SuppressWarnings("serial")
public class EnumControl extends ValueControl {

	protected final JComboBox<String> list;

	private static final Logger log = LogManager.getLogger(EnumControl.class.getName());

	public EnumControl(EnumParam enumParam) {
		super(enumParam);

		this.setMaximumSize(new Dimension(Integer.MAX_VALUE, LINE_HEIGHT));

		list = new JComboBox<String>();
		for (String item : enumParam.getElements()) {
			list.addItem(item);
		}
		list.setEditable(false);
		list.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(ItemEvent itemEvent) {
				notifyOfChange();
			}
		});
		Gui.addLeftToLabel(this, list);
	}

	@Override
	public void pushValueToUserInterfaceImpl(Object value) {
		Integer x = Numbers.cast(value, Integer.class);
		if (x == null) {
			return;
		}
		try {
			list.setSelectedIndex(x - getParam().getMin(Integer.class));
		} catch (IllegalArgumentException e) {
			log.error("failed to set value");
		}
	}

	@Override
	public Object pullValueFromUserInterface() {
		return list.getSelectedIndex();
	}

	@Override
	public EnumParam getParam() {
		return (EnumParam) param;
	}

	@Override
	protected void updateEnabled(boolean enabled) {
		list.setEnabled(enabled);

	}

}
