package com.framsticks.gui.controls;

import javax.swing.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * Listener for component's JPopup menu.
 */
public class ControlPopupListener extends MouseAdapter {

	private JPopupMenu popup;

	public ControlPopupListener(JPopupMenu popup) {
		this.popup = popup;
	}

	@Override
	public void mousePressed(MouseEvent e) {
		if (e.isPopupTrigger()) {
			showPopup(e);
		}
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		if (e.isPopupTrigger()) {
			showPopup(e);
		}
	}

	/**
	 * Shows popup menu if popup trigger fires.
	 *
	 * @param e MouseEvent on which popup menu will be showed.
	 */
	private void showPopup(MouseEvent e) {
		popup.show(e.getComponent(), e.getX(), e.getY());
	}
}
