package com.framsticks.gui.console;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;

import com.framsticks.communication.Connection;
import com.framsticks.communication.ConnectionListener;
import com.framsticks.params.annotations.AutoAppendAnnotation;
import com.framsticks.params.annotations.FramsClassAnnotation;

@FramsClassAnnotation
public class TrackConsole extends Console implements ConnectionListener {

	volatile boolean writeOut = true;
	volatile boolean writeIn = true;

	public TrackConsole() {
	}

	@AutoAppendAnnotation
	public TrackConsole setConnection(Connection connection) {
		this.connection = connection;
		return this;
	}

	@Override
	protected void joinableStart() {
		super.joinableStart();
		connection.getListeners().add(this);
	}

	@Override
	protected void joinableInterrupt() {
		connection.getListeners().remove(this);
		super.joinableInterrupt();
	}

	@Override
	public void connectionOutgoing(String line) {
		if (writeOut) {
			dispatchWrite(line);
		}
	}

	@Override
	public void connectionIncomming(String line) {
		if (writeIn) {
			dispatchWrite(line);
		}
	}

	@Override
	protected void initializeGui() {
		super.initializeGui();

		final Box box = new Box(BoxLayout.LINE_AXIS);

		final JCheckBox outCheckbox = new JCheckBox();
		outCheckbox.setText("Show out");
		outCheckbox.setSelected(true);
		outCheckbox.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				writeOut = outCheckbox.isSelected();
			}
		});

		final JCheckBox inCheckbox = new JCheckBox();
		inCheckbox.setText("Show in");
		inCheckbox.setSelected(true);
		inCheckbox.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				writeIn = inCheckbox.isSelected();
			}
		});

		box.add(outCheckbox);
		box.add(Box.createHorizontalStrut(10));
		box.add(inCheckbox);

		panel.add(box, BorderLayout.PAGE_END);
	}

}
