package com.framsticks.gui.console;

import javax.swing.text.*;
import java.awt.*;

/**
 * Painter class to coloring text background.
 */
public class SimpleLinePainter extends
		DefaultHighlighter.DefaultHighlightPainter {

	private JTextComponent component;
	private DefaultHighlighter highlighter;

	/**
	 * Constructor sets component reference.
	 *
	 * @param component Reference to painted component.
	 * @param color     Background color.
	 */
	public SimpleLinePainter(JTextComponent component, Color color) {
		super(color);

		this.component = component;

		highlighter = (DefaultHighlighter) component.getHighlighter();
		highlighter.setDrawsLayeredHighlights(true);
	}

	/**
	 * Adds highlight in line sets by offset.
	 *
	 * @param offset Line offset.
	 */
	public void addHighlight(int offset) {
		try {
			highlighter.addHighlight(offset, offset + 1, this);
		} catch (BadLocationException ignored) {
		}
	}

	/**
	 * Resets highlight.
	 */
	public void resetHighlight() {

		Element root = component.getDocument().getDefaultRootElement();
		int line = root.getElementIndex(component.getCaretPosition());
		Element lineElement = root.getElement(line);
		int start = lineElement.getStartOffset();
		addHighlight(start);
	}


	public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds,
							JTextComponent c, View view) {
		try {
			Rectangle r = c.modelToView(offs0);
			r.x = 0;
			r.width = c.getSize().width;

			g.setColor(getColor());
			g.fillRect(r.x, r.y, r.width, r.height);
			return r;
		} catch (BadLocationException e) {
			return null;
		}
	}

}
