package com.framsticks.gui;


import com.framsticks.util.FramsticksException;
import com.framsticks.util.dispatching.AbstractJoinable;
import com.framsticks.util.dispatching.Dispatcher;
import com.framsticks.util.dispatching.RunAt;
import com.framsticks.util.dispatching.ThrowExceptionHandler;

public abstract class SwingJoinable<Swing> extends AbstractJoinable implements Dispatcher<SwingJoinable<Swing>> {

	private Swing swing;

	/**
	 * @return the swing
	 */
	public Swing getSwing() {
		if (swing == null) {
			throw new FramsticksException().msg("swing has not yet been initialized").arg("in", this);
		}
		return swing;
	}

	public boolean hasSwing() {
		return swing != null;
	}

	/**
	 * @param swing the swing to set
	 */
	protected void setSwing(Swing swing) {
		this.swing = swing;
	}


	protected abstract void initializeGui();

	@Override
	protected void joinableStart() {
		dispatch(new RunAt<SwingJoinable<Swing>>(ThrowExceptionHandler.getInstance()) {
			@Override
			protected void runAt() {
				initializeGui();
			}
		});
	}

	@Override
	public boolean isActive() {
		return SwingDispatcher.instance.isActive();
	}

	@Override
	public void dispatch(RunAt<? extends SwingJoinable<Swing>> runnable) {
		SwingDispatcher.getInstance().dispatch(runnable);
	}

	@Override
	protected void joinableInterrupt() {

	}

	@Override
	protected void joinableFinish() {

	}

	@Override
	protected void joinableJoin() throws InterruptedException {

	}

}
