package com.framsticks.gui;

import com.framsticks.params.CompositeParam;
import com.framsticks.params.types.ObjectParam;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.collections.functors.NotPredicate;


/**
 * Author: Piotr Śniegowski
 */
public class StandardPanelProvider implements PanelProvider {

	@SuppressWarnings("unchecked")
	@Override
	public TreePanel providePanel(TreePanel.Parameters parameters) {
		if (parameters.param instanceof ObjectParam) {
			return new ObjectPanel(parameters, CollectionUtils.select(parameters.framsClass.getParams(), new NotPredicate(new InstanceofPredicate(CompositeParam.class))));
		}
		return null;
	}
}
