package com.framsticks.gui;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.WindowConstants;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.util.swing.MenuConstructor;

/**
 * Application Main Frame.
 */
@SuppressWarnings("serial")
public class MainFrame extends Frame {

	private final static Logger log = LogManager.getLogger(MainFrame.class.getName());

	JButton start, stop, step;

	/**
	 * Builds main frame.
	 */
	public MainFrame(final Browser browser) {
		super(browser);
		setTitle("framsticks");
		log.debug("creating main frame");

	}


	@Override
	protected void initializeGui() {
		super.initializeGui();

		new MenuConstructor(fileMenu)
			.add(null, new AbstractAction("Console") {
				@Override
				public void actionPerformed(ActionEvent actionEvent) {
					// showConsoleFrame();
				}
			})
			.add(KeyStroke.getKeyStroke(KeyEvent.VK_G, ActionEvent.CTRL_MASK), new AbstractAction("Goto") {
				@Override
				public void actionPerformed(ActionEvent actionEvent) {
					// browser.autoResolvePath("/simulator/genepools/groups/0", null);
					// browser.autoResolvePath("/simulator/populations/groups/0", null;
					// browser.autoResolvePath("/simulator/genepools/groups/0/genotypes", null);
					// browser.autoResolvePath("/simulator/populations/groups", null);
				}
			})
			.add(null, new AbstractAction("Disconnect") {
				@Override
				public void actionPerformed(ActionEvent actionEvent) {
					disconnect();
				}
			})
			.add(null, new AbstractAction("Quit") {
				@Override
				public void actionPerformed(ActionEvent actionEvent) {
				}
			})
			;

		setFrameProperties();
	}


	/**
	 * Sets frame properties.
	 */
	private void setFrameProperties() {
		assert isActive();
		getSwing().setMinimumSize(getSwing().getPreferredSize());
		getSwing().setSize(getSwing().getPreferredSize());
		getSwing().setMaximumSize(screenDimension);
		getSwing().setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);

		getSwing().setIconImage(ImageProvider.loadImage(ImageProvider.LOGO)
				.getImage());


		getSwing().addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				assert isActive();
				/*
				if (connection != null) {
					connection.close();
				}
				*/
				onWindowClosing();
				getSwing().dispose();
			}
		});
	}

	/**
	 * Closes connection with manager.
	 */
	private void disconnect() {
		assert isActive();
		browser.clear();
		onWindowClosing();
		// statusBar.setText("You are disconnected");
	}

	/**
	 * Method used while window is closing.
	 */
	private void onWindowClosing() {
		assert isActive();

	}

	public void setRunningButtons(boolean running) {
		assert isActive();
		step.setEnabled(!running);
		stop.setEnabled(running);
		start.setEnabled(!running);
	}

}

