package com.framsticks.experiment;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.communication.Address;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.running.FramsServer;
import com.framsticks.util.dispatching.Dispatching;
import com.framsticks.util.dispatching.FutureHandler;
import com.framsticks.util.dispatching.Joinable;
import com.framsticks.util.dispatching.JoinableParent;
import com.framsticks.util.dispatching.JoinableState;

@FramsClassAnnotation
public class SimulatorRunner extends SingleSimulatorProvider implements JoinableParent {

	private static final Logger log = LogManager.getLogger(SimulatorRunner.class);

	protected final SimulatorConnector connector;
	protected final FramsServer server;

	/**
	 *
	 */
	public SimulatorRunner() {
		connector = new SimulatorConnector();
		server = new FramsServer();
	}

	@Override
	public String getName() {
		return "simulator runner";
	}

	@Override
	public void provideSimulator(SimulatorSpecification specification, FutureHandler<Simulator> future) {
		if (connector.hasProvided()) {
			future.pass(null);
			return;
		}
		log.debug("running simulator at {}", getAddress());

		if (!getAddress().getHostName().equals("localhost")) {
			server.setHost(getAddress().getHostName());
		}

		server.setPort(getAddress().getPort());
		server.setExpdef(specification.getDefinition());

		Dispatching.use(server, this);

		Dispatching.use(connector, this);
		connector.provideSimulator(specification, future);
	}

	@Override
	public void childChangedState(Joinable joinable, JoinableState state) {
		proceedToState(state);
	}

	@Override
	protected void joinableStart() {
	}

	@Override
	protected void joinableInterrupt() {
		finishJoinable();
	}

	@Override
	protected void joinableFinish() {
		Dispatching.drop(connector, this);
		Dispatching.drop(server, this);
	}

	@Override
	protected void joinableJoin() throws InterruptedException {
		Dispatching.join(connector);
		Dispatching.join(server);
	}

	@Override
	public Address getAddress() {
		return connector.getAddress();
	}

	@Override
	public void setAddress(Address address) {
		connector.setAddress(address);
	}
}
