package com.framsticks.experiment;

import java.util.Iterator;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.util.dispatching.Future;
import com.framsticks.util.dispatching.FutureHandler;
import com.framsticks.util.dispatching.JoinableCollection;

@FramsClassAnnotation
public class SimulatorGroup extends JoinableCollection<SimulatorProvider> implements SimulatorProvider {

	@Override
	public String getName() {
		return "simulator group";
	}


	@Override
	public void provideSimulator(final SimulatorSpecification specification, final FutureHandler<Simulator> future) {
		final Iterator<SimulatorProvider> iterator = joinables.iterator();

		new Future<Simulator>(future) {

			@Override
			protected void result(Simulator result) {
				if (result != null) {
					future.pass(result);
					return;
				}
				if (!iterator.hasNext()) {
					future.pass(null);
					return;
				}
				iterator.next().provideSimulator(specification, this);

			}
		}.pass(null);

	}

}
