package com.framsticks.experiment;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.communication.Address;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.remote.RemoteTree;
import com.framsticks.structure.Path;
import com.framsticks.util.Misc;
import com.framsticks.util.dispatching.Dispatcher;
import com.framsticks.util.dispatching.Dispatching;
import com.framsticks.util.dispatching.Future;
import com.framsticks.util.dispatching.FutureHandler;
import com.framsticks.util.dispatching.Joinable;
import com.framsticks.util.dispatching.JoinableParent;
import com.framsticks.util.dispatching.JoinableState;

import static com.framsticks.structure.TreeOperations.*;

@FramsClassAnnotation
public class SimulatorConnector extends SingleSimulatorProvider implements JoinableParent {
	private static final Logger log = LogManager.getLogger(SimulatorConnector.class);

	protected Experiment experiment;
	protected RemoteTree remoteTree;
	protected Simulator simulator;
	protected Address address;
	protected boolean provided = false;

	public boolean hasProvided() {
		return provided;
	}

	public void setAddress(Address address) {
		this.address = address;
	}

	public Address getAddress() {
		return address;
	}


	@Override
	public String getName() {
		return "simulator connector";
	}

	@Override
	protected void joinableStart() {

	}

	@Override
	protected void joinableInterrupt() {
		Dispatching.drop(remoteTree, this);
		finishJoinable();
	}

	@Override
	protected void joinableFinish() {

	}

	@Override
	protected void joinableJoin() throws InterruptedException {
		Dispatching.join(remoteTree);
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public void provideSimulator(final SimulatorSpecification specification, final FutureHandler<Simulator> future) {
		if (hasProvided()) {
			future.pass(null);
			return;
		}
		provided = true;
		experiment = specification.getExperiment();

		Misc.throwIfNull(address);
		log.debug("connecting to simulator at {}", address);
		// experiment
		remoteTree = new RemoteTree();
		remoteTree.setAddress(address);
		remoteTree.setDispatcher((Dispatcher) experiment.getDispatcher());

		experiment.getSimulatorCandidates().add(remoteTree);
		Dispatching.use(remoteTree, this);

		Dispatching.dispatchLog(remoteTree, log, Level.DEBUG, "first task in remote tree");

		tryGet(remoteTree, "/simulator", new Future<Path>(experiment) {

			@Override
			protected void result(Path result) {
				log.debug("resolved simulator path: {}", result);
				Misc.checkEquals(specification.getDefinition(), bindAccess(result).get("expdef", String.class), "expdef mismatch in connected simulator", SimulatorConnector.this);

				simulator = experiment.createSimulator(remoteTree, result);

				future.pass(simulator);
			}
		});
	}

	@Override
	public void childChangedState(Joinable joinable, JoinableState state) {
		log.debug("child {} changed state to {}", joinable, state);
	}
}
