package com.framsticks.communication.queries;

import com.framsticks.util.lang.Strings;

/**
 * @author Piotr Sniegowski
 */
public class UseRequest extends ProtocolRequest {
	protected String feature;

	public UseRequest feature(String feature) {
		this.feature = feature;
		return this;
	}

	@Override
	public String getCommand() {
		return "use";
	}

	@Override
	protected StringBuilder construct(StringBuilder buffer) {
		return buffer.append(feature);
	}

	@Override
	public CharSequence parseRest(CharSequence rest) {
		feature = rest.toString();
		Strings.assureNotEmpty(feature);
		return null;
	}

	public final String getFeature() {
		return feature;
	}
}
