package com.framsticks.communication.queries;

import java.util.ArrayList;
import java.util.List;

import com.framsticks.util.lang.Delimeted;
import com.framsticks.util.lang.Pair;

/**
 * @author Piotr Sniegowski
 */
public class GetRequest extends ApplicationRequest {
	protected final List<String> fields = new ArrayList<>();

	public GetRequest() {
	}

	public GetRequest fields(List<String> fields) {
		this.fields.clear();
		this.fields.addAll(fields);
		return this;
	}

	public GetRequest field(String field) {
		this.fields.clear();
		this.fields.add(field);
		return this;
	}

	@Override
	public String getCommand() {
		return "get";
	}

	@Override
	protected StringBuilder construct(StringBuilder buffer) {
		super.construct(buffer);
		if (!fields.isEmpty()) {
			buffer.append(' ').append(new Delimeted<String>(",", "").append(fields.iterator()));
		}
		return buffer;
	}

	/**
	 * @return the fields
	 */
	public List<String> getFields() {
		return fields;
	}

	@Override
	public CharSequence parseRest(CharSequence rest) {
		rest = super.parseRest(rest);
		Pair<CharSequence, CharSequence> p = takeIdentifier(rest);
		if (p != null) {
			for (String a : p.first.toString().split(",")) {
				fields.add(a);
			}
		}
		return null;
	}
}
