package com.framsticks.communication;

import java.util.Arrays;
import java.util.List;

/**
 * @author Piotr Sniegowski
 */
public class Response {
	protected final boolean ok;
	protected final String comment;
	protected final List<File> files;

	public Response(boolean ok, String comment, File... files) {
		this(ok, comment, (files.length == 0 ? null : Arrays.asList(files)));
	}

	public Response(boolean ok, String comment, List<File> files) {
		this.ok = ok;
		this.comment = comment;
		this.files = files;
	}

	public final String getComment() {
		return comment;
	}

	public final boolean getOk() {
		return ok;
	}

	public final List<File> getFiles() {
		return files;
	}

	public final boolean hasFiles() {
		return files != null && !files.isEmpty();
	}
}
