package com.framsticks.communication;


import javax.annotation.Nonnull;

import com.framsticks.params.Source;
// import com.framsticks.util.lang.Strings;
import com.framsticks.util.lang.Strings;

/**
 * @author Piotr Sniegowski
 */
public final class File {
	protected final String path;
	protected final Source content;

	public File(@Nonnull String path, @Nonnull Source content) {
		// assert Strings.notEmpty(path);
		this.path = path;
		this.content = content;
	}

	public String getPath() {
		return path;
	}

	public Source getContent() {
		return content;
	}

	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		if (Strings.notEmpty(path)) {
			b.append(path).append(": ");
		}
		b.append(content.toString());
		return b.toString();
	}

}
