package com.framsticks.communication;

import com.framsticks.util.ExceptionHandler;
import com.framsticks.util.FramsticksException;
import com.framsticks.util.dispatching.Future;

public abstract class ClientSideResponseFuture extends Future<Response> {

	public ClientSideResponseFuture(ExceptionHandler handler) {
		super(handler);
	}

	protected Request request;

	protected abstract void processOk(Response response);

	@Override
	protected final void result(Response response) {
		if (response.getOk()) {
			processOk(response);
		} else {
			handle(new FramsticksException().msg("invalid response").arg("comment", response.getComment()).arg("request", request));
		}
	}

	/**
	 * @return the request
	 */
	public Request getRequest() {
		return request;
	}

	/**
	 * @param request the request to set
	 */
	public void setRequest(Request request) {
		this.request = request;
	}

}
