package com.framsticks.communication;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.util.ExceptionHandler;
import com.framsticks.util.dispatching.RunAt;

@FramsClassAnnotation
public class ClientSideRawConnection extends Connection {

	public ClientSideRawConnection() {
		setDescription("client raw connection");
	}

	@Override
	protected void receiverThreadRoutine() {
		startClientConnection(this);

		processInputBatchesUntilClosed();
	}

	protected void processNextInputBatch() {
		getLine();
	}

	public void send(final String line, ExceptionHandler handler) {

		senderThread.dispatch(new RunAt<ClientSideRawConnection>(handler) {
			@Override
			protected void runAt() {
				putLine(line);
				flushOut();
			}
		});

	}

}
