package games.league;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Scanner;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;

public class WPCSequenceVisualizer {

	public WPCSequenceVisualizer() {
		
	}
	
	private PdfPTable createTable(double[] wpc) {
		System.err.println(Arrays.toString(wpc));

		PdfPTable table = new PdfPTable(8);
		for (int i = 0; i < 64; i++) {
			PdfPCell cell = new PdfPCell(new Paragraph(" "));
			cell.setBorder(Rectangle.NO_BORDER);
			cell.setPadding(0.4f);
			if (wpc[i] >= 0) {
				cell.setBackgroundColor(new Color(0, Math.min(1, (float)wpc[i]), 0));					
			} else {
				cell.setBackgroundColor(new Color(Math.min(1, Math.abs((float)wpc[i])), 0, 0));
			}
			table.addCell(cell);
		}
		
		return table;
	}
	
	public void visualize(String fileIn, String fileOut, int limit, int frequency) {
		Document document = new Document(PageSize.A4, 0, 0, 0, 0);
		document.setMarginMirroring(true);

		try {
			PdfWriter.getInstance(document, new FileOutputStream(fileOut));
			document.open();
			
			
			PdfPTable table = new PdfPTable(4);
			Scanner sc = new Scanner(new FileReader(fileIn));
			for (int gen = 0; gen <= limit; gen++) {
				for (int i = 0; i < 8; i++) {
					sc.next();
				}
				
				double[] wpc = new double[64];
				for (int i = 0; i < 64; i++) {
					wpc[i] = sc.nextDouble();
				}
				
				if ((gen % frequency) == 0) {
					PdfPCell cell = new PdfPCell(createTable(wpc));
					cell.setBorder(Rectangle.NO_BORDER);
					cell.setPadding(8.0f);
					table.addCell(cell);
				}
			}
			
			table.setComplete(true);
			table.setWidthPercentage(85);
			document.add(table);
			
		} catch (Exception e) {
			e.printStackTrace();
		} 
		
		document.close();
	}
	
	public static void main(String[] args) {
		WPCSequenceVisualizer vis = new WPCSequenceVisualizer();
		vis.visualize("out.stat", "out.pdf", 840, 30);
	}
}