package cecj.app.go;

import java.util.Arrays;

import cecj.app.othello.OthelloBoard;
import ec.util.MersenneTwisterFast;
import games.Player;

public class GoPlayer implements Player {

	private static final int WPC_LENGTH = 25;

	private double[] wpc;

	public GoPlayer() {
		this.wpc = new double[WPC_LENGTH];
	}
	
	public GoPlayer(double[] wpc) {
		this.wpc = wpc;
	}

	public double getValue(int row, int col) {
		return wpc[(row - 1) * GoBoard.size() + (col - 1)];
	}
	
	public double[] getWPC() {
		return wpc;
	}

	public void setValue(int row, int col, double value) {
		wpc[(row - 1) * GoBoard.size() + (col - 1)] = value; 
	}
	
	@Override
	public String toString() {
		return Arrays.toString(wpc);
	}
	
	public void randomize(MersenneTwisterFast random, double range) {
		for (int i = 0; i < WPC_LENGTH; i++) {
			wpc[i] = random.nextDouble() * range;
			if (random.nextBoolean()) {
				wpc[i] *= -1;
			}
		}
	}

}
