package com.framsticks.framclipse.syntaxColoring;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.SWT;

import com.framsticks.framclipse.Framclipse;


public class FramscriptPropertyCodeScanner extends RuleBasedScanner {

	public final static String[] keywords = { "asm", "break", "call", "case", "continue",
			"default", "do", "else", "for", "function", "global", "goto", "if", "return", "switch",
			"typeof", "var", "while", };

	public final static String[] operators = { "(", ")", "[", "]", "{", "}", "}", "=", "<", ">",
			"*", "/", "+", "-", "!", ";", "." };

	public FramscriptPropertyCodeScanner() {
		ColorManager colorManager = Framclipse.getDefault().getColorManager();
		IToken keyword = new Token(new TextAttribute(colorManager
				.getColor(FramclipseColors.KEYWORD), null, SWT.BOLD));
		IToken comment = new Token(new TextAttribute(colorManager
				.getColor(FramclipseColors.COMMENT)));
		IToken string = new Token(new TextAttribute(colorManager.getColor(FramclipseColors.STRING)));
		IToken number = new Token(new TextAttribute(colorManager.getColor(FramclipseColors.NUMBER)));
		IToken code = new Token(new TextAttribute(colorManager.getColor(FramclipseColors.CODE)));
		IToken operator = new Token(new TextAttribute(colorManager
				.getColor(FramclipseColors.OPERATOR)));

		List<IRule> rules = new ArrayList<IRule>();
		rules.add(new EndOfLineRule("//", comment));
		rules.add(new SingleLineRule("\"", "\"", string, '\\'));
		rules.add(new SingleLineRule("\'", "\'", string, '\\'));

		WordRule numberRule = new WordRule(new FramscriptNumberDetector(), number);
		rules.add(numberRule);

		WordRule operatorRule = new WordRule(new FramscriptOperatorDetector(), code);
		for (int i = 0; i < operators.length; i++) {
			operatorRule.addWord(operators[i], operator);
		}
		rules.add(operatorRule);

		WordRule keywordRule = new WordRule(new FramscriptWordDetector(), code);
		for (int i = 0; i < keywords.length; i++) {
			keywordRule.addWord(keywords[i], keyword);
		}
		rules.add(keywordRule);

		setDefaultReturnToken(code);

		IRule[] result = new IRule[rules.size()];
		result = rules.toArray(result);
		setRules(result);
	}
}
